/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.caching;

import com.db4o.cs.caching.ClientSlotCache;
import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectInfoEventArgs;
import com.db4o.foundation.Function4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionLocal;
import com.db4o.internal.caching.CacheFactory;
import com.db4o.internal.caching.PurgeableCache4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSlotCacheImpl
implements ClientSlotCache {
    private static final Function4<Integer, ByteArrayBuffer> nullProducer = new Function4<Integer, ByteArrayBuffer>(){

        @Override
        public ByteArrayBuffer apply(Integer arg) {
            return null;
        }
    };
    private final TransactionLocal<PurgeableCache4<Integer, ByteArrayBuffer>> _cache = new TransactionLocal<PurgeableCache4<Integer, ByteArrayBuffer>>(){

        @Override
        public PurgeableCache4<Integer, ByteArrayBuffer> initialValueFor(Transaction transaction) {
            Config4Impl config = transaction.container().config();
            return CacheFactory.newLRUIntCache(config.prefetchSlotCacheSize());
        }
    };

    public ClientSlotCacheImpl(ClientObjectContainer clientObjectContainer) {
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer(clientObjectContainer);
        eventRegistry.activated().addListener(new EventListener4<ObjectInfoEventArgs>(){

            @Override
            public void onEvent(Event4 e, ObjectInfoEventArgs args) {
                ClientSlotCacheImpl.this.purge((Transaction)args.transaction(), (int)args.info().getInternalID());
            }
        });
    }

    @Override
    public void add(Transaction provider, int id, final ByteArrayBuffer slot) {
        this.purge(provider, id);
        this.cacheOn(provider).produce(id, new Function4<Integer, ByteArrayBuffer>(){

            @Override
            public ByteArrayBuffer apply(Integer arg) {
                return slot;
            }
        }, null);
    }

    @Override
    public ByteArrayBuffer get(Transaction provider, int id) {
        ByteArrayBuffer buffer = this.cacheOn(provider).produce(id, nullProducer, null);
        if (null == buffer) {
            return null;
        }
        buffer.seek(0);
        return buffer;
    }

    private void purge(Transaction provider, int id) {
        this.cacheOn(provider).purge(id);
    }

    private PurgeableCache4<Integer, ByteArrayBuffer> cacheOn(Transaction provider) {
        return (PurgeableCache4)provider.get(this._cache).value;
    }
}

