/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.DTrace;
import com.db4o.cs.foundation.Socket4;
import com.db4o.cs.internal.ClassInfoHelper;
import com.db4o.cs.internal.ClientTransactionHandle;
import com.db4o.cs.internal.FatalServerShutdown;
import com.db4o.cs.internal.LazyClientObjectSetStub;
import com.db4o.cs.internal.MessageEventArgs;
import com.db4o.cs.internal.ObjectServerImpl;
import com.db4o.cs.internal.ServerMessageDispatcher;
import com.db4o.cs.internal.ShutdownMode;
import com.db4o.cs.internal.Socket4Adapter;
import com.db4o.cs.internal.messages.MSwitchToFile;
import com.db4o.cs.internal.messages.MUseTransaction;
import com.db4o.cs.internal.messages.Message;
import com.db4o.cs.internal.messages.MessageWithResponse;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.cs.internal.messages.ServerSideMessage;
import com.db4o.events.Event4;
import com.db4o.ext.Db4oException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.Db4oRecoverableException;
import com.db4o.foundation.Hashtable4;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Transaction;
import com.db4o.internal.events.Event4Impl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerMessageDispatcherImpl
implements ServerMessageDispatcher,
Runnable {
    private String _clientName;
    private boolean _loggedin;
    private boolean _closeMessageSent;
    private final ObjectServerImpl _server;
    private Socket4Adapter _socket;
    private final ClientTransactionHandle _transactionHandle;
    private Hashtable4 _queryResults;
    final int _threadID;
    private CallbackObjectInfoCollections _committedInfo;
    private boolean _caresAboutCommitted;
    private boolean _isClosed;
    private final Object _lock = new Object();
    private final Object _mainLock;
    private final Event4Impl<MessageEventArgs> _messageReceived = Event4Impl.newInstance();
    private Thread _thread;

    ServerMessageDispatcherImpl(ObjectServerImpl server, ClientTransactionHandle transactionHandle, Socket4 socket4, int threadID, boolean loggedIn, Object mainLock) throws Exception {
        this._mainLock = mainLock;
        this._transactionHandle = transactionHandle;
        this._loggedin = loggedIn;
        this._server = server;
        this._threadID = threadID;
        this._socket = new Socket4Adapter(socket4);
        this._socket.setSoTimeout(((Config4Impl)server.configure()).timeoutServerSocket());
    }

    @Override
    public boolean close() {
        return this.close(ShutdownMode.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(ShutdownMode mode) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return true;
            }
            this._isClosed = true;
        }
        object = this._mainLock;
        synchronized (object) {
            this._transactionHandle.releaseTransaction(mode);
            if (!mode.isFatal()) {
                this.sendCloseMessage();
            }
            this._transactionHandle.close(mode);
            this.closeSocket();
            this.removeFromServer();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection() {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return;
            }
            this._isClosed = true;
        }
        object = this._mainLock;
        synchronized (object) {
            this.closeSocket();
            this.removeFromServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMessageDispatcherAlive() {
        Object object = this._lock;
        synchronized (object) {
            return !this._isClosed;
        }
    }

    private void sendCloseMessage() {
        try {
            if (!this._closeMessageSent) {
                this._closeMessageSent = true;
                this.write(Msg.CLOSE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeFromServer() {
        try {
            this._server.removeThread(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSocket() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (Db4oIOException db4oIOException) {
            // empty catch block
        }
    }

    @Override
    public Transaction transaction() {
        return this._transactionHandle.transaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._thread = Thread.currentThread();
        try {
            this.setDispatcherName("" + this._threadID);
            this._server.withEnvironment(new Runnable(){

                public void run() {
                    ServerMessageDispatcherImpl.this.messageLoop();
                }
            });
        }
        finally {
            this.close();
        }
    }

    private void messageLoop() {
        while (this.isMessageDispatcherAlive()) {
            try {
                if (this.messageProcessor()) continue;
                return;
            }
            catch (Db4oIOException e) {
                if (DTrace.enabled) {
                    DTrace.ADD_TO_CLASS_INDEX.log(e.toString());
                }
                return;
            }
        }
    }

    private boolean messageProcessor() throws Db4oIOException {
        Msg message = Msg.readMessage(this, this.transaction(), this._socket);
        if (message == null) {
            return true;
        }
        this.triggerMessageReceived(message);
        if (!this._loggedin && !Msg.LOGIN.equals(message)) {
            return true;
        }
        return this.processMessage(message);
    }

    @Override
    public boolean processMessage(Msg message) {
        if (this.isMessageDispatcherAlive()) {
            if (message instanceof MessageWithResponse) {
                MessageWithResponse msgWithResp = (MessageWithResponse)((Object)message);
                try {
                    Msg reply = msgWithResp.replyFromServer();
                    this.write(reply);
                }
                catch (Db4oRecoverableException exc) {
                    this.writeException(message, exc);
                    return true;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.fatalShutDownServer(t);
                    return false;
                }
                try {
                    msgWithResp.postProcessAtServer();
                    return true;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return true;
                }
            }
            try {
                ((ServerSideMessage)((Object)message)).processAtServer();
                return true;
            }
            catch (Db4oRecoverableException exc) {
                exc.printStackTrace();
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.fatalShutDownServer(t);
            }
        }
        return false;
    }

    private void fatalShutDownServer(Throwable origExc) {
        new FatalServerShutdown(this._server, origExc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeException(Msg message, Exception exc) {
        if (!(message instanceof MessageWithResponse)) {
            exc.printStackTrace();
            return;
        }
        if (!(exc instanceof RuntimeException)) {
            exc = new Db4oException(exc);
        }
        this.ensureStackTraceCapture(exc);
        Object object = this._mainLock;
        synchronized (object) {
            message.writeException((RuntimeException)exc);
        }
    }

    private void ensureStackTraceCapture(Exception exc) {
        exc.printStackTrace(new PrintStream(new OutputStream(){

            public void write(int arg0) throws IOException {
            }
        }));
    }

    private void triggerMessageReceived(Message message) {
        this._messageReceived.trigger(new MessageEventArgs(message));
    }

    @Override
    public ObjectServerImpl server() {
        return this._server;
    }

    @Override
    public void queryResultFinalized(int queryResultID) {
        this._queryResults.remove(queryResultID);
    }

    @Override
    public void mapQueryResultToID(LazyClientObjectSetStub stub, int queryResultID) {
        if (this._queryResults == null) {
            this._queryResults = new Hashtable4();
        }
        this._queryResults.put(queryResultID, (Object)stub);
    }

    @Override
    public LazyClientObjectSetStub queryResultForID(int queryResultID) {
        return (LazyClientObjectSetStub)this._queryResults.get(queryResultID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchToFile(MSwitchToFile message) {
        Object object = this._mainLock;
        synchronized (object) {
            String fileName = message.readString();
            try {
                this._transactionHandle.releaseTransaction(ShutdownMode.NORMAL);
                this._transactionHandle.acquireTransactionForFile(fileName);
                this.write(Msg.OK);
            }
            catch (Exception e) {
                this._transactionHandle.releaseTransaction(ShutdownMode.NORMAL);
                this.write(Msg.ERROR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchToMainFile() {
        Object object = this._mainLock;
        synchronized (object) {
            this._transactionHandle.releaseTransaction(ShutdownMode.NORMAL);
            this.write(Msg.OK);
        }
    }

    @Override
    public void useTransaction(MUseTransaction message) {
        int threadID = message.readInt();
        Transaction transToUse = this._server.findTransaction(threadID);
        this._transactionHandle.transaction(transToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(Msg msg) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isMessageDispatcherAlive()) {
                return false;
            }
            return msg.write(this._socket);
        }
    }

    @Override
    public Socket4Adapter socket() {
        return this._socket;
    }

    @Override
    public String name() {
        return this._clientName;
    }

    @Override
    public void setDispatcherName(String name) {
        this._clientName = name;
        this.thread().setName("db4o server message dispatcher " + name);
    }

    @Override
    public int dispatcherID() {
        return this._threadID;
    }

    @Override
    public void login() {
        this._loggedin = true;
    }

    @Override
    public boolean caresAboutCommitted() {
        return this._caresAboutCommitted;
    }

    @Override
    public void caresAboutCommitted(boolean care) {
        this._caresAboutCommitted = true;
        this.server().checkCaresAboutCommitted();
    }

    @Override
    public CallbackObjectInfoCollections committedInfo() {
        return this._committedInfo;
    }

    @Override
    public void dispatchCommitted(CallbackObjectInfoCollections committedInfo) {
        this._committedInfo = committedInfo;
    }

    @Override
    public boolean willDispatchCommitted() {
        return this.server().caresAboutCommitted();
    }

    @Override
    public ClassInfoHelper classInfoHelper() {
        return this.server().classInfoHelper();
    }

    @Override
    public Event4<MessageEventArgs> messageReceived() {
        return this._messageReceived;
    }

    @Override
    public void join() throws InterruptedException {
        this.thread().join();
    }

    private Thread thread() {
        if (null == this._thread) {
            throw new IllegalStateException();
        }
        return this._thread;
    }
}

