/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.ObjectSet;
import com.db4o.User;
import com.db4o.config.Configuration;
import com.db4o.cs.config.ServerConfiguration;
import com.db4o.cs.foundation.ServerSocket4;
import com.db4o.cs.foundation.Socket4;
import com.db4o.cs.foundation.Socket4Factory;
import com.db4o.cs.internal.BroadcastFilter;
import com.db4o.cs.internal.ClassInfoHelper;
import com.db4o.cs.internal.ClientConnectionEventArgs;
import com.db4o.cs.internal.ClientTransactionHandle;
import com.db4o.cs.internal.ClientTransactionPool;
import com.db4o.cs.internal.CommittedCallbacksDispatcher;
import com.db4o.cs.internal.ObjectServerEvents;
import com.db4o.cs.internal.ServerClosedEventArgs;
import com.db4o.cs.internal.ServerMessageDispatcher;
import com.db4o.cs.internal.ServerMessageDispatcherImpl;
import com.db4o.cs.internal.ShutdownMode;
import com.db4o.cs.internal.config.Db4oClientServerLegacyConfigurationBridge;
import com.db4o.cs.internal.config.ServerConfigurationImpl;
import com.db4o.cs.internal.messages.MCommittedInfo;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.events.Event4;
import com.db4o.events.StringEventArgs;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.ExtObjectServer;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Lock4;
import com.db4o.internal.CallBackMode;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerSession;
import com.db4o.internal.Transaction;
import com.db4o.internal.config.CommonConfigurationImpl;
import com.db4o.internal.events.Event4Impl;
import com.db4o.internal.threading.ThreadPool4;
import com.db4o.types.TransientClass;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectServerImpl
implements ObjectServerEvents,
ObjectServer,
ExtObjectServer,
Runnable,
TransientClass {
    private static final int START_THREAD_WAIT_TIMEOUT = 5000;
    private final String _name;
    private ServerSocket4 _serverSocket;
    private int _port;
    private int i_threadIDGen = 1;
    private final Collection4 _dispatchers = new Collection4();
    private LocalObjectContainer _container;
    private ClientTransactionPool _transactionPool;
    private final Lock4 _startupLock = new Lock4();
    private ServerConfigurationImpl _serverConfig;
    private BlockingQueue _committedInfosQueue = new BlockingQueue();
    private CommittedCallbacksDispatcher _committedCallbacksDispatcher;
    private boolean _caresAboutCommitted;
    private final Socket4Factory _socketFactory;
    private final boolean _isEmbeddedServer;
    private final ClassInfoHelper _classInfoHelper;
    private final Event4Impl<StringEventArgs> _clientDisconnected = Event4Impl.newInstance();
    private final Event4Impl<ClientConnectionEventArgs> _clientConnected = Event4Impl.newInstance();
    private final Event4Impl<ServerClosedEventArgs> _closed = Event4Impl.newInstance();

    public ObjectServerImpl(LocalObjectContainer container, ServerConfiguration serverConfig, int port) {
        this(container, (ServerConfigurationImpl)serverConfig, port < 0 ? 0 : port, port == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectServerImpl(LocalObjectContainer container, ServerConfigurationImpl serverConfig, int port, boolean isEmbeddedServer) {
        this._isEmbeddedServer = isEmbeddedServer;
        this._container = container;
        this._serverConfig = serverConfig;
        this._socketFactory = serverConfig.networking().socketFactory();
        this._transactionPool = new ClientTransactionPool(container);
        this._port = port;
        this._name = "db4o ServerSocket FILE: " + container.toString() + "  PORT:" + this._port;
        this._container.setServer(true);
        this.configureObjectServer();
        this._classInfoHelper = new ClassInfoHelper(Db4oClientServerLegacyConfigurationBridge.asLegacy(serverConfig));
        this._container.classCollection().checkAllClassChanges();
        boolean ok = false;
        try {
            this.ensureLoadStaticClass();
            this.startCommittedCallbackThread(this._committedInfosQueue);
            this.startServer();
            if (this._serverConfig != null) {
                this._serverConfig.applyConfigurationItems(this);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.close();
            }
        }
    }

    private void startServer() {
        if (this.isEmbeddedServer()) {
            return;
        }
        this._startupLock.run(new Closure4(){

            public Object run() {
                ObjectServerImpl.this.startServerSocket();
                ObjectServerImpl.this.startServerThread();
                boolean started = false;
                while (!started) {
                    try {
                        ObjectServerImpl.this._startupLock.snooze(5000L);
                        started = true;
                    }
                    catch (Exception exception) {}
                }
                return null;
            }
        });
    }

    private void startServerThread() {
        this._startupLock.run(new Closure4(){

            public Object run() {
                ObjectServerImpl.this.threadPool().start(ObjectServerImpl.this._name, ObjectServerImpl.this);
                return null;
            }
        });
    }

    private ThreadPool4 threadPool() {
        return this._container.threadPool();
    }

    private void startServerSocket() {
        try {
            this._serverSocket = this._socketFactory.createServerSocket(this._port);
            this._port = this._serverSocket.getLocalPort();
        }
        catch (IOException e) {
            throw new Db4oIOException(e);
        }
        this._serverSocket.setSoTimeout(this._serverConfig.timeoutServerSocket());
    }

    private boolean isEmbeddedServer() {
        return this._isEmbeddedServer;
    }

    private void ensureLoadStaticClass() {
        this._container.produceClassMetadata(this._container._handlers.ICLASS_STATICCLASS);
    }

    private void configureObjectServer() {
        ((CommonConfigurationImpl)this._serverConfig.common()).callbackMode(CallBackMode.DELETE_ONLY);
        this._serverConfig.common().objectClass(User.class).minimumActivationDepth(1);
    }

    @Override
    public void backup(String path) throws IOException {
        this._container.backup(path);
    }

    final void checkClosed() {
        if (this._container == null) {
            Exceptions4.throwRuntimeException(20, this._name);
        }
        this._container.checkClosed();
    }

    public void dispose() {
        this.close();
    }

    @Override
    public synchronized boolean close() {
        return this.close(ShutdownMode.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean close(ShutdownMode mode) {
        try {
            this.closeServerSocket();
            this.stopCommittedCallbacksDispatcher();
            this.closeMessageDispatchers(mode);
            boolean bl = this.closeFile(mode);
            return bl;
        }
        finally {
            this.triggerClosed();
        }
    }

    private void stopCommittedCallbacksDispatcher() {
        if (this._committedCallbacksDispatcher != null) {
            this._committedCallbacksDispatcher.stop();
        }
    }

    private boolean closeFile(ShutdownMode mode) {
        if (this._container != null) {
            this._transactionPool.close(mode);
            this._container = null;
        }
        return true;
    }

    private void closeMessageDispatchers(ShutdownMode mode) {
        Iterator4 i = this.iterateDispatchers();
        while (i.moveNext()) {
            try {
                ((ServerMessageDispatcher)i.current()).close(mode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator4 iterateDispatchers() {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            return new Collection4(this._dispatchers).iterator();
        }
    }

    private void closeServerSocket() {
        try {
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._serverSocket = null;
    }

    @Override
    public Configuration configure() {
        return Db4oClientServerLegacyConfigurationBridge.asLegacy(this._serverConfig);
    }

    @Override
    public ExtObjectServer ext() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessageDispatcherImpl findThread(int a_threadID) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            Iterator4 i = this._dispatchers.iterator();
            while (i.moveNext()) {
                ServerMessageDispatcherImpl serverThread = (ServerMessageDispatcherImpl)i.current();
                if (serverThread._threadID != a_threadID) continue;
                return serverThread;
            }
        }
        return null;
    }

    Transaction findTransaction(int threadID) {
        ServerMessageDispatcherImpl dispatcher = this.findThread(threadID);
        return dispatcher == null ? null : dispatcher.transaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void grantAccess(String userName, String password) {
        this.checkClosed();
        Object object = this._container.lock();
        synchronized (object) {
            User existing = this.getUser(userName);
            if (existing != null) {
                this.setPassword(existing, password);
            } else {
                this.addUser(userName, password);
            }
            this._container.commit();
        }
    }

    private void addUser(String userName, String password) {
        this._container.store(new User(userName, password));
    }

    private void setPassword(User existing, String password) {
        existing.password = password;
        this._container.store(existing);
    }

    public User getUser(String userName) {
        ObjectSet result = this.queryUsers(userName);
        if (!result.hasNext()) {
            return null;
        }
        return (User)result.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSet queryUsers(String userName) {
        this._container.showInternalClasses(true);
        try {
            ObjectSet objectSet = this._container.queryByExample(new User(userName, null));
            return objectSet;
        }
        finally {
            this._container.showInternalClasses(false);
        }
    }

    @Override
    public ObjectContainer objectContainer() {
        return this._container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ObjectContainer openClient() {
        this.checkClosed();
        Object object = this._container.lock();
        synchronized (object) {
            return new ObjectContainerSession(this._container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeThread(ServerMessageDispatcherImpl dispatcher) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            this._dispatchers.remove(dispatcher);
            this.checkCaresAboutCommitted();
        }
        this.triggerClientDisconnected(dispatcher.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void revokeAccess(String userName) {
        this.checkClosed();
        Object object = this._container.lock();
        synchronized (object) {
            this.deleteUsers(userName);
            this._container.commit();
        }
    }

    private void deleteUsers(String userName) {
        ObjectSet set = this.queryUsers(userName);
        while (set.hasNext()) {
            this._container.delete(set.next());
        }
    }

    @Override
    public void run() {
        this.logListeningOnPort();
        this.notifyThreadStarted();
        this.listen();
    }

    private void startCommittedCallbackThread(BlockingQueue committedInfosQueue) {
        if (this.isEmbeddedServer()) {
            return;
        }
        this._committedCallbacksDispatcher = new CommittedCallbacksDispatcher(this, committedInfosQueue);
        this.threadPool().start("Server commit callback dispatcher thread", this._committedCallbacksDispatcher);
    }

    private void listen() {
        final LocalObjectContainer threadContainer = this._container;
        while (this._serverSocket != null) {
            threadContainer.withEnvironment(new Runnable(){

                public void run() {
                    try {
                        Socket4 socket = ObjectServerImpl.this._serverSocket.accept();
                        ServerMessageDispatcherImpl messageDispatcher = new ServerMessageDispatcherImpl(ObjectServerImpl.this, new ClientTransactionHandle(ObjectServerImpl.this._transactionPool), socket, ObjectServerImpl.this.newThreadId(), false, threadContainer.lock());
                        ObjectServerImpl.this.addServerMessageDispatcher(messageDispatcher);
                        ObjectServerImpl.this.threadPool().start("server message dispatcher (still initializing)", messageDispatcher);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void triggerClientConnected(ServerMessageDispatcher messageDispatcher) {
        this._clientConnected.trigger(new ClientConnectionEventArgs(messageDispatcher));
    }

    private void triggerClientDisconnected(String clientName) {
        this._clientDisconnected.trigger(new StringEventArgs(clientName));
    }

    private void triggerClosed() {
        this._closed.trigger(new ServerClosedEventArgs());
    }

    private void notifyThreadStarted() {
        this._startupLock.run(new Closure4(){

            public Object run() {
                ObjectServerImpl.this._startupLock.awake();
                return null;
            }
        });
    }

    private void logListeningOnPort() {
        this._container.logMsg(31, "" + this._serverSocket.getLocalPort());
    }

    private int newThreadId() {
        return this.i_threadIDGen++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServerMessageDispatcher(ServerMessageDispatcher dispatcher) {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            this._dispatchers.add(dispatcher);
            this.checkCaresAboutCommitted();
        }
        this.triggerClientConnected(dispatcher);
    }

    public void addCommittedInfoMsg(MCommittedInfo message) {
        this._committedInfosQueue.add(message);
    }

    public void broadcastReplicationCommit(long timestamp, List concurrentTimestamps) {
        Iterator4 i = this.iterateDispatchers();
        while (i.moveNext()) {
            ServerMessageDispatcher dispatcher = (ServerMessageDispatcher)i.current();
            LocalTransaction transaction = (LocalTransaction)dispatcher.transaction();
            transaction.notifyAboutOtherReplicationCommit(timestamp, concurrentTimestamps);
        }
    }

    public void broadcastMsg(Msg message, BroadcastFilter filter) {
        Iterator4 i = this.iterateDispatchers();
        while (i.moveNext()) {
            ServerMessageDispatcher dispatcher = (ServerMessageDispatcher)i.current();
            if (!filter.accept(dispatcher)) continue;
            dispatcher.write(message);
        }
    }

    public boolean caresAboutCommitted() {
        return this._caresAboutCommitted;
    }

    public void checkCaresAboutCommitted() {
        this._caresAboutCommitted = this.anyDispatcherCaresAboutCommitted();
    }

    private boolean anyDispatcherCaresAboutCommitted() {
        Iterator4 i = this.iterateDispatchers();
        while (i.moveNext()) {
            ServerMessageDispatcher dispatcher = (ServerMessageDispatcher)i.current();
            if (!dispatcher.caresAboutCommitted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int port() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clientCount() {
        Collection4 collection4 = this._dispatchers;
        synchronized (collection4) {
            return this._dispatchers.size();
        }
    }

    public ClassInfoHelper classInfoHelper() {
        return this._classInfoHelper;
    }

    @Override
    public Event4<ClientConnectionEventArgs> clientConnected() {
        return this._clientConnected;
    }

    @Override
    public Event4<StringEventArgs> clientDisconnected() {
        return this._clientDisconnected;
    }

    @Override
    public Event4<ServerClosedEventArgs> closed() {
        return this._closed;
    }

    void withEnvironment(Runnable runnable) {
        this._container.withEnvironment(runnable);
    }

    public int transactionCount() {
        return this._transactionPool.openTransactionCount();
    }
}

