/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.internal.ClientTransactionPool;
import com.db4o.cs.internal.ShutdownMode;
import com.db4o.internal.Transaction;

public class ClientTransactionHandle {
    private final ClientTransactionPool _transactionPool;
    private Transaction _mainTransaction;
    private Transaction _transaction;
    private boolean _rollbackOnClose;

    public ClientTransactionHandle(ClientTransactionPool transactionPool) {
        this._transactionPool = transactionPool;
        this._mainTransaction = this._transactionPool.acquireMain();
        this._rollbackOnClose = true;
    }

    public void acquireTransactionForFile(String fileName) {
        this._transaction = this._transactionPool.acquire(fileName);
    }

    public void releaseTransaction(ShutdownMode mode) {
        if (this._transaction != null) {
            this._transactionPool.release(mode, this._transaction, this._rollbackOnClose);
            this._transaction = null;
        }
    }

    public boolean isClosed() {
        return this._transactionPool.isClosed();
    }

    public void close(ShutdownMode mode) {
        if (!this._transactionPool.isClosed() && this._mainTransaction != null) {
            this._transactionPool.release(mode, this._mainTransaction, this._rollbackOnClose);
        }
    }

    public Transaction transaction() {
        if (this._transaction != null) {
            return this._transaction;
        }
        return this._mainTransaction;
    }

    public void transaction(Transaction transaction) {
        if (this._transaction != null) {
            this._transaction = transaction;
        } else {
            this._mainTransaction = transaction;
        }
        this._rollbackOnClose = false;
    }
}

