/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.internal.ClassInfo;
import com.db4o.cs.internal.FieldInfo;
import com.db4o.foundation.Hashtable4;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericClass;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericReflector;
import java.util.ArrayList;

public class ClassInfoHelper {
    private Hashtable4 _classMetaTable = new Hashtable4();
    private Hashtable4 _genericClassTable = new Hashtable4();
    private Config4Impl _config;

    public ClassInfoHelper(Config4Impl config) {
        this._config = config;
    }

    public ClassInfo getClassMeta(ReflectClass claxx) {
        if (ClassInfoHelper.isObjectClass(claxx)) {
            return ClassInfo.newSystemClass(claxx.getName());
        }
        ClassInfo existing = this.lookupClassMeta(claxx.getName());
        if (existing != null) {
            return existing;
        }
        return this.newUserClassMeta(claxx);
    }

    private ClassInfo newUserClassMeta(ReflectClass claxx) {
        ClassInfo classMeta = ClassInfo.newUserClass(claxx.getName());
        classMeta.setSuperClass(this.mapSuperclass(claxx));
        this.registerClassMeta(claxx.getName(), classMeta);
        classMeta.setFields(this.mapFields(claxx.getDeclaredFields(), this.shouldStoreTransientFields(claxx)));
        return classMeta;
    }

    private boolean shouldStoreTransientFields(ReflectClass claxx) {
        Config4Class configClass = this._config.configClass(claxx.getName());
        return configClass == null ? false : configClass.storeTransientFields();
    }

    private ClassInfo mapSuperclass(ReflectClass claxx) {
        ReflectClass superClass = claxx.getSuperclass();
        if (superClass != null) {
            return this.getClassMeta(superClass);
        }
        return null;
    }

    private FieldInfo[] mapFields(ReflectField[] fields, boolean shouldStoreTransientFields) {
        if (!shouldStoreTransientFields) {
            fields = this.filterTransientFields(fields);
        }
        FieldInfo[] fieldsMeta = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ReflectField field = fields[i];
            boolean isArray = field.getFieldType().isArray();
            ReflectClass fieldClass = isArray ? field.getFieldType().getComponentType() : field.getFieldType();
            boolean isPrimitive = fieldClass.isPrimitive();
            fieldsMeta[i] = new FieldInfo(field.getName(), this.getClassMeta(fieldClass), isPrimitive, isArray, false);
        }
        return fieldsMeta;
    }

    private ReflectField[] filterTransientFields(ReflectField[] fields) {
        ArrayList<ReflectField> filteredFields = new ArrayList<ReflectField>();
        for (ReflectField field : fields) {
            if (field.isTransient()) continue;
            filteredFields.add(field);
        }
        return filteredFields.toArray(new ReflectField[filteredFields.size()]);
    }

    private static boolean isObjectClass(ReflectClass claxx) {
        return claxx.reflector().forClass(Const4.CLASS_OBJECT) == claxx;
    }

    private ClassInfo lookupClassMeta(String className) {
        return (ClassInfo)this._classMetaTable.get(className);
    }

    private void registerClassMeta(String className, ClassInfo classMeta) {
        this._classMetaTable.put(className, (Object)classMeta);
    }

    public GenericClass classMetaToGenericClass(GenericReflector reflector, ClassInfo classMeta) {
        if (classMeta.isSystemClass()) {
            return (GenericClass)reflector.forName(classMeta.getClassName());
        }
        String className = classMeta.getClassName();
        GenericClass genericClass = this.lookupGenericClass(className);
        if (genericClass != null) {
            return genericClass;
        }
        ReflectClass reflectClass = reflector.forName(className);
        if (reflectClass != null) {
            return (GenericClass)reflectClass;
        }
        GenericClass genericSuperClass = null;
        ClassInfo superClassMeta = classMeta.getSuperClass();
        if (superClassMeta != null) {
            genericSuperClass = this.classMetaToGenericClass(reflector, superClassMeta);
        }
        genericClass = new GenericClass(reflector, null, className, genericSuperClass);
        this.registerGenericClass(className, genericClass);
        FieldInfo[] fields = classMeta.getFields();
        GenericField[] genericFields = new GenericField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ClassInfo fieldClassMeta = fields[i].getFieldClass();
            String fieldName = fields[i].getFieldName();
            GenericClass genericFieldClass = this.classMetaToGenericClass(reflector, fieldClassMeta);
            genericFields[i] = new GenericField(fieldName, genericFieldClass, fields[i]._isPrimitive);
        }
        genericClass.initFields(genericFields);
        return genericClass;
    }

    private GenericClass lookupGenericClass(String className) {
        return (GenericClass)this._genericClassTable.get(className);
    }

    private void registerGenericClass(String className, GenericClass classMeta) {
        this._genericClassTable.put(className, (Object)classMeta);
        ((GenericReflector)classMeta.reflector()).register(classMeta);
    }
}

