/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.consistency;

import com.db4o.Db4oEmbedded;
import com.db4o.EmbeddedObjectContainer;
import com.db4o.ObjectContainer;
import com.db4o.consistency.ConsistencyReport;
import com.db4o.consistency.FreespaceSlotDetail;
import com.db4o.consistency.IdObjectSlotDetail;
import com.db4o.consistency.OverlapMap;
import com.db4o.consistency.RawObjectSlotDetail;
import com.db4o.consistency.SlotDetail;
import com.db4o.ext.InvalidIDException;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Pair;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.ids.BTreeIdSystem;
import com.db4o.internal.ids.IdSlotMapping;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.slots.Slot;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistencyChecker {
    private final List<SlotDetail> _bogusSlots = new ArrayList<SlotDetail>();
    private final LocalObjectContainer _db;
    private final OverlapMap _overlaps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        EmbeddedObjectContainer db = Db4oEmbedded.openFile(args[0]);
        try {
            System.out.println(new ConsistencyChecker(db).checkSlotConsistency());
        }
        finally {
            db.close();
        }
    }

    public ConsistencyChecker(ObjectContainer db) {
        this._db = (LocalObjectContainer)db;
        this._overlaps = new OverlapMap(this._db.blockConverter());
    }

    public ConsistencyReport checkSlotConsistency() {
        return this._db.syncExec(new Closure4<ConsistencyReport>(){

            @Override
            public ConsistencyReport run() {
                ConsistencyChecker.this.mapIdSystem();
                ConsistencyChecker.this.mapFreespace();
                return new ConsistencyReport(ConsistencyChecker.this._bogusSlots, ConsistencyChecker.this._overlaps, ConsistencyChecker.this.checkClassIndices(), ConsistencyChecker.this.checkFieldIndices());
            }
        });
    }

    private List<Pair<String, Integer>> checkClassIndices() {
        final ArrayList<Pair<String, Integer>> invalidIds = new ArrayList<Pair<String, Integer>>();
        IdSystem idSystem = this._db.idSystem();
        if (!(idSystem instanceof BTreeIdSystem)) {
            return invalidIds;
        }
        ClassMetadataIterator clazzIter = this._db.classCollection().iterator();
        while (clazzIter.moveNext()) {
            final ClassMetadata clazz = clazzIter.currentClass();
            if (!clazz.hasClassIndex()) continue;
            BTreeClassIndexStrategy index = (BTreeClassIndexStrategy)clazz.index();
            index.traverseAll(this._db.systemTransaction(), new Visitor4<Integer>(){

                @Override
                public void visit(Integer id) {
                    if (!ConsistencyChecker.this.idIsValid(id)) {
                        invalidIds.add(new Pair<String, Integer>(clazz.getName(), id));
                    }
                }
            });
        }
        return invalidIds;
    }

    private List<Pair<String, Integer>> checkFieldIndices() {
        final ArrayList<Pair<String, Integer>> invalidIds = new ArrayList<Pair<String, Integer>>();
        ClassMetadataIterator clazzIter = this._db.classCollection().iterator();
        while (clazzIter.moveNext()) {
            final ClassMetadata clazz = clazzIter.currentClass();
            clazz.traverseDeclaredFields(new Procedure4<FieldMetadata>(){

                @Override
                public void apply(final FieldMetadata field) {
                    if (!field.hasIndex()) {
                        return;
                    }
                    BTree fieldIndex = field.getIndex(ConsistencyChecker.this._db.systemTransaction());
                    fieldIndex.traverseKeys(ConsistencyChecker.this._db.systemTransaction(), new Visitor4<FieldIndexKey>(){

                        @Override
                        public void visit(FieldIndexKey fieldIndexKey) {
                            int parentID = fieldIndexKey.parentID();
                            if (!ConsistencyChecker.this.idIsValid(parentID)) {
                                invalidIds.add(new Pair<String, Integer>(clazz.getName() + "#" + field.getName(), parentID));
                            }
                        }
                    });
                }
            });
        }
        return invalidIds;
    }

    private boolean idIsValid(int id) {
        try {
            return !Slot.isNull(this._db.idSystem().committedSlot(id));
        }
        catch (InvalidIDException exc) {
            return false;
        }
    }

    private void mapFreespace() {
        this._db.freespaceManager().traverse(new Visitor4<Slot>(){

            @Override
            public void visit(Slot slot) {
                FreespaceSlotDetail detail = new FreespaceSlotDetail(slot);
                if (ConsistencyChecker.this.isBogusSlot(slot.address(), slot.length())) {
                    ConsistencyChecker.this._bogusSlots.add(detail);
                }
                ConsistencyChecker.this._overlaps.add(detail);
            }
        });
    }

    private void mapIdSystem() {
        IdSystem idSystem = this._db.idSystem();
        if (!(idSystem instanceof BTreeIdSystem)) {
            System.err.println("No btree id system found - not mapping ids.");
            return;
        }
        ((BTreeIdSystem)idSystem).traverseIds(new Visitor4<IdSlotMapping>(){

            @Override
            public void visit(IdSlotMapping mapping) {
                IdObjectSlotDetail detail = new IdObjectSlotDetail(mapping._id, mapping.slot());
                if (ConsistencyChecker.this.isBogusSlot(mapping._address, mapping._length)) {
                    ConsistencyChecker.this._bogusSlots.add(detail);
                }
                if (mapping._address > 0) {
                    ConsistencyChecker.this._overlaps.add(detail);
                }
            }
        });
        idSystem.traverseOwnSlots(new Procedure4<Pair<Integer, Slot>>(){

            @Override
            public void apply(Pair<Integer, Slot> idSlot) {
                SlotDetail detail;
                int id = (Integer)idSlot.first;
                Slot slot = (Slot)idSlot.second;
                SlotDetail slotDetail = detail = id > 0 ? new IdObjectSlotDetail(id, slot) : new RawObjectSlotDetail(slot);
                if (ConsistencyChecker.this.isBogusSlot(((Slot)idSlot.second).address(), ((Slot)idSlot.second).length())) {
                    ConsistencyChecker.this._bogusSlots.add(detail);
                }
                ConsistencyChecker.this._overlaps.add(detail);
            }
        });
    }

    private boolean isBogusSlot(int address, int length) {
        return address < 0 || (long)address + (long)length > this._db.fileLength();
    }
}

