/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections;

import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.collections.ActivatableSet;
import com.db4o.collections.ActivatableSupport;
import com.db4o.collections.ActivatingIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivatableTreeSet<E>
extends TreeSet<E>
implements ActivatableSet<E> {
    private transient Activator _activator;

    public ActivatableTreeSet() {
    }

    public ActivatableTreeSet(Comparator<? super E> comparator) {
        super(comparator);
    }

    public ActivatableTreeSet(Collection<? extends E> c) {
        super(c);
    }

    public ActivatableTreeSet(SortedSet<E> s) {
        super(s);
    }

    @Override
    public void activate(ActivationPurpose purpose) {
        ActivatableSupport.activate(this._activator, purpose);
    }

    @Override
    public void bind(Activator activator) {
        this._activator = ActivatableSupport.validateForBind(this._activator, activator);
    }

    @Override
    public boolean add(E e) {
        this.activate(ActivationPurpose.WRITE);
        return super.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.activate(ActivationPurpose.WRITE);
        return super.addAll(c);
    }

    @Override
    public void clear() {
        this.activate(ActivationPurpose.WRITE);
        super.clear();
    }

    @Override
    public Object clone() {
        this.activate(ActivationPurpose.READ);
        ActivatableTreeSet cloned = (ActivatableTreeSet)super.clone();
        cloned._activator = null;
        return cloned;
    }

    @Override
    public boolean contains(Object o) {
        this.activate(ActivationPurpose.READ);
        return super.contains(o);
    }

    @Override
    public E first() {
        this.activate(ActivationPurpose.READ);
        return super.first();
    }

    @Override
    public boolean isEmpty() {
        this.activate(ActivationPurpose.READ);
        return super.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.activate(ActivationPurpose.READ);
        return new ActivatingIterator(this, super.iterator());
    }

    @Override
    public E last() {
        this.activate(ActivationPurpose.READ);
        return super.last();
    }

    @Override
    public boolean remove(Object o) {
        this.activate(ActivationPurpose.WRITE);
        return super.remove(o);
    }

    @Override
    public int size() {
        this.activate(ActivationPurpose.READ);
        return super.size();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        this.activate(ActivationPurpose.READ);
        return super.subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        this.activate(ActivationPurpose.READ);
        return super.headSet(toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        this.activate(ActivationPurpose.READ);
        return super.tailSet(fromElement);
    }
}

