/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;

public class NewMultiArrayExpr
extends Expr {
    Expr[] dimensions;
    Type elementType;

    public NewMultiArrayExpr(Expr[] dimensions, Type elementType, Type type) {
        super(type);
        this.elementType = elementType;
        this.dimensions = dimensions;
        int i = 0;
        while (i < dimensions.length) {
            dimensions[i].setParent(this);
            ++i;
        }
    }

    public Expr[] dimensions() {
        return this.dimensions;
    }

    public Type elementType() {
        return this.elementType;
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            int i = this.dimensions.length - 1;
            while (i >= 0) {
                this.dimensions[i].visit(visitor);
                --i;
            }
        } else {
            int i = 0;
            while (i < this.dimensions.length) {
                this.dimensions[i].visit(visitor);
                ++i;
            }
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitNewMultiArrayExpr(this);
    }

    public int exprHashCode() {
        int v = 17;
        int i = 0;
        while (i < this.dimensions.length) {
            v ^= this.dimensions[i].hashCode();
            ++i;
        }
        return v;
    }

    public boolean equalsExpr(Expr other) {
        return false;
    }

    public Object clone() {
        Expr[] d = new Expr[this.dimensions.length];
        int i = 0;
        while (i < this.dimensions.length) {
            d[i] = (Expr)this.dimensions[i].clone();
            ++i;
        }
        return this.copyInto(new NewMultiArrayExpr(d, this.elementType, this.type));
    }
}

