/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.optimize;

import EDU.purdue.cs.bloat.cfg.DominatorTree;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.VerifyCFG;
import EDU.purdue.cs.bloat.codegen.CodeGenerator;
import EDU.purdue.cs.bloat.codegen.Liveness;
import EDU.purdue.cs.bloat.codegen.RegisterAllocator;
import EDU.purdue.cs.bloat.context.BloatContext;
import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.diva.InductionVarAnalyzer;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.CodeArray;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassFile;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.inline.StackHeightCounter;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.ssa.SSA;
import EDU.purdue.cs.bloat.ssa.SSAGraph;
import EDU.purdue.cs.bloat.tbaa.TypeInference;
import EDU.purdue.cs.bloat.trans.CompactArrayInitializer;
import EDU.purdue.cs.bloat.trans.DeadCodeElimination;
import EDU.purdue.cs.bloat.trans.ExprPropagation;
import EDU.purdue.cs.bloat.trans.Peephole;
import EDU.purdue.cs.bloat.trans.PersistentCheckElimination;
import EDU.purdue.cs.bloat.trans.SSAPRE;
import EDU.purdue.cs.bloat.trans.StackOpt;
import EDU.purdue.cs.bloat.trans.StackPRE;
import EDU.purdue.cs.bloat.trans.ValueFolding;
import EDU.purdue.cs.bloat.trans.ValueNumbering;
import EDU.purdue.cs.bloat.tree.StackOptimizer;
import EDU.purdue.cs.bloat.tree.Tree;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Main {
    static boolean DEBUG = false;
    static boolean VERBOSE = false;
    public static boolean TRACE = false;
    static boolean FORCE = false;
    static boolean CLOSURE = false;
    static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);
    static boolean DIVA = false;
    public static boolean PRE = true;
    public static boolean DCE = true;
    public static boolean PROP = true;
    public static boolean FOLD = true;
    public static boolean INFER = true;
    public static boolean NUMBER = true;
    public static boolean PERSIST = false;
    public static boolean STACK_ALLOC = false;
    public static boolean COMPACT_ARRAY_INIT = true;
    static boolean ANNO = true;
    public static boolean VERIFY = true;
    public static boolean OPT_STACK_1 = false;
    public static boolean OPT_STACK_2 = false;
    static String[] ARGS = null;
    public static List SKIP = new ArrayList();
    static List ONLY = new ArrayList();
    static String METHOD = null;
    static BloatContext context = null;
    static ClassFileLoader loader = null;

    public static void main(String[] args) {
        try {
            Iterator e;
            loader = new ClassFileLoader();
            ArrayList<String> classes = new ArrayList<String>(args.length);
            boolean gotdir = false;
            ARGS = args;
            int i = 0;
            while (i < args.length) {
                String pkg;
                String classpath;
                if (args[i].equals("-v") || args[i].equals("-verbose")) {
                    VERBOSE = true;
                    loader.setVerbose(true);
                } else if (args[i].equals("-debug")) {
                    DEBUG = true;
                    loader.setVerbose(true);
                    ClassFileLoader.DEBUG = true;
                    CompactArrayInitializer.DEBUG = true;
                    ClassEditor.DEBUG = true;
                    FlowGraph.DEBUG = true;
                    DominatorTree.DEBUG = true;
                    Tree.DEBUG = true;
                    CodeGenerator.DEBUG = true;
                    Liveness.DEBUG = true;
                    SSA.DEBUG = true;
                    SSAGraph.DEBUG = true;
                    PersistentCheckElimination.DEBUG = true;
                    ValueNumbering.DEBUG = true;
                    ValueFolding.DEBUG = true;
                    ClassHierarchy.DEBUG = true;
                    TypeInference.DEBUG = true;
                    SSAPRE.DEBUG = true;
                    StackPRE.DEBUG = true;
                    ExprPropagation.DEBUG = true;
                    DeadCodeElimination.DEBUG = true;
                    CodeGenerator.DB_OPT_STACK = true;
                } else if (args[i].equals("-trace")) {
                    TRACE = true;
                } else if (args[i].equals("-db")) {
                    if (++i >= args.length) {
                        System.err.println("** No debugging option specified");
                        Main.usage();
                    }
                    if (args[i].equals("bc")) {
                        CodeArray.DEBUG = true;
                    } else if (args[i].equals("cfg")) {
                        FlowGraph.DEBUG = true;
                    } else if (args[i].equals("ssa")) {
                        SSA.DEBUG = true;
                        SSAGraph.DEBUG = true;
                    } else if (args[i].equals("graphs")) {
                        FlowGraph.DB_GRAPHS = true;
                    } else if (args[i].startsWith("-")) {
                        --i;
                    } else {
                        System.err.println("** Unknown debugging option: " + args[i]);
                        Main.usage();
                    }
                } else if (args[i].equals("-debugvf")) {
                    ValueFolding.DUMP = true;
                } else if (args[i].equals("-debugbc")) {
                    BloatContext.DEBUG = true;
                } else if (args[i].equals("-help")) {
                    Main.usage();
                } else if (args[i].equals("-noanno")) {
                    ANNO = false;
                } else if (args[i].equals("-anno")) {
                    ANNO = true;
                } else if (args[i].equals("-print-flow-graph")) {
                    FlowGraph.PRINT_GRAPH = true;
                } else if (args[i].equals("-preserve-debug")) {
                    MethodEditor.PRESERVE_DEBUG = true;
                } else if (args[i].equals("-nouse-stack-vars")) {
                    Tree.USE_STACK = false;
                } else if (args[i].equals("-use-stack-vars")) {
                    Tree.USE_STACK = true;
                } else if (args[i].equals("-unique-handlers")) {
                    MethodEditor.UNIQUE_HANDLERS = true;
                } else if (args[i].equals("-nocompact-array-init")) {
                    COMPACT_ARRAY_INIT = false;
                } else if (args[i].equals("-compact-array-init")) {
                    COMPACT_ARRAY_INIT = true;
                } else if (args[i].equals("-nostack-alloc")) {
                    STACK_ALLOC = false;
                } else if (args[i].equals("-stack-alloc")) {
                    STACK_ALLOC = true;
                } else if (args[i].equals("-no-verify")) {
                    VERIFY = false;
                } else if (args[i].equals("-peel-loops")) {
                    String n;
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    if ((n = args[i]).equals("all")) {
                        FlowGraph.PEEL_LOOPS_LEVEL = -1;
                    } else {
                        try {
                            FlowGraph.PEEL_LOOPS_LEVEL = Integer.parseInt(n);
                            if (FlowGraph.PEEL_LOOPS_LEVEL < 0) {
                                Main.usage();
                            }
                        }
                        catch (NumberFormatException ex) {
                            Main.usage();
                        }
                    }
                } else if (args[i].equals("-color")) {
                    Liveness.UNIQUE = false;
                } else if (args[i].equals("-nocolor")) {
                    Liveness.UNIQUE = true;
                } else if (args[i].equals("-only-method")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    METHOD = args[i];
                } else if (args[i].equals("-classpath")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    classpath = args[i];
                    loader.setClassPath(classpath);
                } else if (args[i].equals("-classpath/p")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    classpath = args[i];
                    loader.prependClassPath(classpath);
                } else if (args[i].equals("-skip")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    if ((pkg = args[i]).endsWith(".class")) {
                        pkg = pkg.substring(0, pkg.lastIndexOf(46));
                    }
                    SKIP.add(pkg.replace('.', '/'));
                } else if (args[i].equals("-only")) {
                    if (++i >= args.length) {
                        Main.usage();
                    }
                    if ((pkg = args[i]).endsWith(".class")) {
                        pkg = pkg.substring(0, pkg.lastIndexOf(46));
                    }
                    ONLY.add(pkg.replace('.', '/'));
                } else if (args[i].equals("-nodce")) {
                    DCE = false;
                } else if (args[i].equals("-noprop")) {
                    PROP = false;
                } else if (args[i].equals("-noappre")) {
                    SSAPRE.NO_ACCESS_PATHS = true;
                } else if (args[i].equals("-nopre")) {
                    PRE = false;
                } else if (args[i].equals("-dce")) {
                    DCE = true;
                } else if (args[i].equals("-prop")) {
                    PROP = true;
                } else if (args[i].equals("-appre")) {
                    SSAPRE.NO_ACCESS_PATHS = false;
                } else if (args[i].equals("-pre")) {
                    PRE = true;
                } else if (args[i].equals("-closure")) {
                    CLOSURE = true;
                } else if (args[i].equals("-opt-stack-1")) {
                    OPT_STACK_1 = true;
                    CodeGenerator.OPT_STACK = true;
                } else if (args[i].equals("-opt-stack-2")) {
                    OPT_STACK_2 = true;
                    MethodEditor.OPT_STACK_2 = true;
                } else if (args[i].equals("-diva")) {
                    DIVA = true;
                } else if (args[i].equals("-no-thread")) {
                    SSAPRE.NO_THREAD = true;
                } else if (args[i].equals("-no-precise")) {
                    SSAPRE.NO_PRECISE = true;
                } else if (args[i].equals("-relax-loading")) {
                    ClassHierarchy.RELAX = true;
                } else if (args[i].equals("-f") || args[i].equals("-force")) {
                    FORCE = true;
                } else if (args[i].startsWith("-")) {
                    System.err.println("No such option: " + args[i]);
                    Main.usage();
                } else if (i == args.length - 1) {
                    File f = new File(args[i]);
                    if (f.exists() && !f.isDirectory()) {
                        System.err.println("No such directory: " + f.getPath());
                        System.exit(2);
                    }
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    if (!f.exists()) {
                        System.err.println("Couldn't create directory: " + f.getPath());
                        System.exit(2);
                    }
                    loader.setOutputDir(f);
                    gotdir = true;
                } else {
                    classes.add(args[i]);
                }
                ++i;
            }
            if (!gotdir) {
                System.err.println("No output directory specified");
                Main.usage();
            }
            if (classes.size() == 0) {
                System.err.println("** No classes specified");
                Main.usage();
            }
            context = new CachingBloatContext(loader, classes, CLOSURE);
            boolean errors = false;
            Iterator iter = classes.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                try {
                    context.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println("Couldn't find class: " + ex.getMessage());
                    errors = true;
                }
            }
            if (errors) {
                System.exit(1);
            }
            if (!CLOSURE) {
                e = classes.iterator();
                while (e.hasNext()) {
                    String name = (String)e.next();
                    Main.editClass(name);
                }
            } else {
                classes = null;
                if (TRACE) {
                    System.out.println("Computing closure " + dateFormat.format(new Date()));
                }
                e = context.getHierarchy().classes().iterator();
                while (e.hasNext()) {
                    Type t = (Type)e.next();
                    if (!t.isObject()) continue;
                    Main.editClass(t.className());
                }
            }
        }
        catch (ExceptionInInitializerError ex) {
            ex.printStackTrace();
            System.out.println(ex.getException());
        }
    }

    private static void usage() {
        System.err.println("\nUsage: java EDU.purdue.cs.bloat.optimize.Main\n            [-options] classes dir\n\nwhere options include:\n    -help             print out this message\n    -v -verbose       turn on verbose mode\n    -debug            display a hideous amount of debug info\n    -classpath <directories separated by colons>\n                      list directories in which to look for classes\n    -f                optimize files even if up-to-date\n    -closure          recursively optimize referenced classes\n    -relax-loading    don't report errors if a class is not found\n    -skip <class|package.*>\n                      skip the given class or package\n    -only <class|package.*>\n                      skip all but the given class or package\n    -preserve-debug   try to preserve debug information\n    -[no]anno         insert an annotation in the contant pool\n    -[no]stack-alloc  try to push locals onto the operand stack\n    -peel-loops <n|all>\n                      peel innermost loops to enable code hoisting\n                      (n >= 0 is the maximum loop level to peel)\n    -[no]pre          perform partial redundency elimination\n    -[no]dce          perform dead code elimination\n    -diva             perform demand-driven induction variable analysis\n    -[no]prop         perform copy and constant propagation");
        System.exit(0);
    }

    /*
     * Unable to fully structure code
     */
    private static void editClass(String className) {
        try {
            classFile = (ClassFile)Main.context.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("** Couldn't find class: " + ex.getMessage());
            return;
        }
        if (!Main.FORCE) {
            source = classFile.file();
            target = classFile.outputFile();
            if (source != null && target != null && source.exists() && target.exists() && source.lastModified() < target.lastModified()) {
                if (Main.VERBOSE) {
                    System.out.println(String.valueOf(classFile.name()) + " is up to date");
                }
                return;
            }
        }
        if (Main.DEBUG) {
            classFile.print(System.out);
        }
        c = Main.context.editClass(classFile);
        skip = false;
        name = c.type().className();
        qual = String.valueOf(c.type().qualifier()) + "/*";
        if (Main.ONLY.size() > 0) {
            skip = true;
            i = 0;
            while (i < Main.ONLY.size()) {
                pkg = (String)Main.ONLY.get(i);
                if (name.equals(pkg) || qual.equals(pkg)) {
                    skip = false;
                    break;
                }
                ++i;
            }
        }
        if (!skip) {
            i = 0;
            while (i < Main.SKIP.size()) {
                pkg = (String)Main.SKIP.get(i);
                if (name.equals(pkg) || qual.equals(pkg)) {
                    skip = true;
                    break;
                }
                ++i;
            }
        }
        if (skip) {
            if (Main.VERBOSE) {
                System.out.println("Skipping " + c.type().className());
            }
            Main.context.release(classFile);
            return;
        }
        try {
            f = classFile.outputFile();
            if (f.exists()) {
                f.delete();
            }
            dir = new File(f.getParent());
            dir.mkdirs();
            if (!dir.exists()) {
                throw new RuntimeException("Couldn't create directory: " + dir);
            }
            out = new DataOutputStream(new FileOutputStream(f));
            new PrintStream(out).println();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (Main.VERBOSE) {
            System.out.println("Optimizing " + c.type().className());
        }
        methods = c.methods();
        numMethods = methods.length + 1;
        whichMethod = 0;
        j = 0;
        while (j < methods.length) {
            block33: {
                try {
                    m = Main.context.editMethod(methods[j]);
                }
                catch (ClassFormatException ex) {
                    System.err.println(ex.getMessage());
                    break block33;
                }
                if (Main.TRACE) {
                    System.out.println("Optimizing " + name + "." + m.name() + " (method " + ++whichMethod + " of " + numMethods + ")");
                }
                if (Main.METHOD == null) ** GOTO lbl-1000
                pass = true;
                t = String.valueOf(m.name()) + m.type();
                if (t.equals(Main.METHOD)) {
                    pass = false;
                }
                if ((t = m.name()).equals(Main.METHOD)) {
                    pass = false;
                }
                if (pass) {
                    Main.context.release(methods[j]);
                } else lbl-1000:
                // 2 sources

                {
                    if (Main.DEBUG) {
                        m.print(System.out);
                    }
                    if (m.isNative() || m.isAbstract()) {
                        Main.context.release(methods[j]);
                    } else {
                        Main.bloatMethod(m, Main.context);
                    }
                }
            }
            ++j;
        }
        if (Main.ANNO) {
            s = "Optimized with: EDU.purdue.cs.bloat.optimize.Main";
            i = 0;
            while (i < Main.ARGS.length) {
                s = Main.ARGS[i].indexOf(32) >= 0 || Main.ARGS[i].indexOf(9) >= 0 || Main.ARGS[i].indexOf(13) >= 0 || Main.ARGS[i].indexOf(10) >= 0 ? String.valueOf(s) + " '" + Main.ARGS[i] + "'" : String.valueOf(s) + " " + Main.ARGS[i];
                ++i;
            }
            System.out.println(s);
        }
        Main.context.commit(classFile);
        Main.context.release(classFile);
        if (Main.TRACE) {
            System.out.println(Main.context.toString());
        }
    }

    public static void bloatMethod(MethodEditor m, BloatContext context) {
        try {
            FlowGraph cfg;
            if (COMPACT_ARRAY_INIT) {
                if (TRACE) {
                    System.out.println("  Compacting Arrays: " + dateFormat.format(new Date()));
                }
                CompactArrayInitializer.transform(m);
                if (DEBUG) {
                    System.out.println("---------- After compaction:");
                    m.print(System.out);
                    System.out.println("---------- end print");
                }
            }
            if (TRACE) {
                System.out.println("  Constructing CFG: " + dateFormat.format(new Date()));
            }
            try {
                cfg = new FlowGraph(m);
            }
            catch (ClassFormatException ex) {
                System.err.println(ex.getMessage());
                context.release(m.methodInfo());
                return;
            }
            cfg.initialize();
            if (TRACE) {
                System.out.println("  Transforming to SSA: " + dateFormat.format(new Date()));
            }
            SSA.transform(cfg);
            if (FlowGraph.DEBUG) {
                System.out.println("---------- After SSA:");
                cfg.print(System.out);
                System.out.println("---------- end print");
            }
            if (DEBUG) {
                cfg.visit(new VerifyCFG(false));
            }
            if (!Tree.USE_STACK && PROP) {
                if (DEBUG) {
                    System.out.println("-----Before Copy Propagation-----");
                }
                if (TRACE) {
                    System.out.println("  Copy propagation: " + dateFormat.format(new Date()));
                }
                ExprPropagation copy = new ExprPropagation(cfg);
                copy.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG(false));
                }
                if (DEBUG) {
                    System.out.println("------After Copy Propagation-----");
                    cfg.print(System.out);
                }
            }
            DeadCodeElimination dce = null;
            if (DCE) {
                if (TRACE) {
                    System.out.println("  Dead Code Elimination: " + dateFormat.format(new Date()));
                }
                if (DEBUG) {
                    System.out.println("---Before Dead Code Elimination--");
                }
                dce = new DeadCodeElimination(cfg);
                dce.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG(false));
                }
                if (DEBUG) {
                    System.out.println("---After Dead Code Elimination---");
                    cfg.print(System.out);
                }
            }
            if (INFER) {
                if (DEBUG) {
                    System.out.println("---------Doing type inference--------");
                }
                if (TRACE) {
                    System.out.println("  Type Inferencing: " + dateFormat.format(new Date()));
                }
                TypeInference.transform(cfg, context.getHierarchy());
            }
            if (NUMBER) {
                if (TRACE) {
                    System.out.println("  Value Numbering: " + dateFormat.format(new Date()));
                }
                if (DEBUG) {
                    System.out.println("--------Doing value numbering--------");
                }
                new ValueNumbering().transform(cfg);
            }
            if (FOLD) {
                if (DEBUG) {
                    System.out.println("--------Before Value Folding---------");
                }
                if (TRACE) {
                    System.out.println("  Value Folding: " + dateFormat.format(new Date()));
                }
                new ValueFolding().transform(cfg);
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("---------After Value Folding---------");
                    cfg.print(System.out);
                }
            }
            if (PRE) {
                if (DEBUG) {
                    System.out.println("-------------Before SSAPRE-----------");
                }
                if (TRACE) {
                    System.out.println("  SSAPRE: " + dateFormat.format(new Date()));
                }
                SSAPRE pre = new SSAPRE(cfg, context);
                pre.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("-------------After SSAPRE------------");
                    cfg.print(System.out);
                }
            }
            if (FOLD) {
                if (DEBUG) {
                    System.out.println("--------Before Value Folding---------");
                }
                if (TRACE) {
                    System.out.println("  Value Folding: " + dateFormat.format(new Date()));
                }
                new ValueFolding().transform(cfg);
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("---------After Value Folding---------");
                    cfg.print(System.out);
                }
            }
            if (PROP) {
                if (DEBUG) {
                    System.out.println("-------Before Copy Propagation-------");
                }
                if (TRACE) {
                    System.out.println("  Copy Propagation " + dateFormat.format(new Date()));
                }
                ExprPropagation copy = new ExprPropagation(cfg);
                copy.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("--------After Copy Propagation-------");
                    cfg.print(System.out);
                }
            }
            if (DCE && (INFER || NUMBER || FOLD || PRE || PROP)) {
                if (DEBUG) {
                    System.out.println("-----Before Dead Code Elimination----");
                }
                if (TRACE) {
                    System.out.println("  Dead Code Elimination: " + dateFormat.format(new Date()));
                }
                dce = new DeadCodeElimination(cfg);
                dce.transform();
                if (DEBUG) {
                    cfg.visit(new VerifyCFG());
                }
                if (DEBUG) {
                    System.out.println("-----After Dead Code Elimination-----");
                    cfg.print(System.out);
                }
            }
            if (PERSIST) {
                new PersistentCheckElimination().transform(cfg);
            }
            if (DIVA) {
                if (DEBUG) {
                    System.out.println("-----Before DIVA------");
                }
                if (TRACE) {
                    System.out.println("  DIVA: " + dateFormat.format(new Date()));
                }
                new InductionVarAnalyzer().transform(cfg);
                if (DEBUG) {
                    System.out.println("-----After DIVA-----");
                    cfg.print(System.out);
                }
            }
            if (OPT_STACK_2) {
                if (TRACE) {
                    System.out.println("  New stack optimization: " + dateFormat.format(new Date()));
                }
                CodeGenerator codegen = new CodeGenerator(m);
                codegen.replacePhis(cfg);
                m.clearCode2();
                cfg.visit(codegen);
                StackOpt so = new StackOpt();
                so.transform(m);
                cfg = new FlowGraph(m);
                cfg.initialize();
                SSA.transform(cfg);
                dce = new DeadCodeElimination(cfg);
                dce.transform();
            }
            if (TRACE) {
                System.out.println("  Register allocation: " + dateFormat.format(new Date()));
            }
            if (VERIFY) {
                try {
                    cfg.visit(new VerifyCFG());
                }
                catch (IllegalArgumentException ee) {
                    System.out.println(" NOTE: CFG did not verify while bloating " + m.name() + " after all optimizations. Exception: " + ee);
                }
            }
            Liveness liveness = new Liveness(cfg);
            RegisterAllocator alloc = new RegisterAllocator(cfg, liveness);
            if (CodeGenerator.OPT_STACK) {
                if (TRACE) {
                    System.out.println("  Old stack optimization: " + dateFormat.format(new Date()));
                }
                StackOptimizer.optimizeCFG(cfg);
            }
            if (TRACE) {
                System.out.println("  Code Generation: " + dateFormat.format(new Date()));
            }
            CodeGenerator codegen = new CodeGenerator(m);
            codegen.replacePhis(cfg);
            if (DEBUG) {
                System.out.println("After fixing Phis------------------------");
                cfg.print(System.out);
                System.out.println("End print--------------------------------");
            }
            codegen.simplifyControlFlow(cfg);
            codegen.allocReturnAddresses(cfg, alloc);
            if (DEBUG) {
                System.out.println("After removing empty blocks--------------");
                cfg.print(System.out);
                System.out.println("End print--------------------------------");
            }
            m.clearCode();
            cfg.visit(codegen);
            Peephole.transform(m);
            context.commit(m.methodInfo());
        }
        catch (Exception ex99) {
            String msg = "** Exception while optimizing " + m.name() + m.type() + " of class " + m.declaringClass().name();
            System.err.println(msg);
            System.err.println(ex99.getMessage());
            ex99.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void dumpcode(MethodEditor m) {
        PrintWriter out = new PrintWriter(System.out, true);
        StackHeightCounter shc = new StackHeightCounter(m);
        out.println("Code for method " + m.name() + m.type());
        List instructions = m.code();
        ListIterator iter = instructions.listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Label) {
                shc.handle((Label)obj);
            } else if (obj instanceof Instruction) {
                shc.handle((Instruction)obj);
            }
            System.out.println("        " + obj + " (sh: " + shc.height() + ")");
        }
    }
}

