/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.inline;

import EDU.purdue.cs.bloat.editor.IncOperand;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Switch;
import EDU.purdue.cs.bloat.editor.TryCatch;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.inline.InlineContext;
import EDU.purdue.cs.bloat.inline.Mapper;
import EDU.purdue.cs.bloat.inline.StackHeightCounter;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Inline {
    public static boolean DEBUG = false;
    private int maxCodeSize;
    private int maxCallDepth;
    private boolean inlineExceptions;
    private InlineContext context;
    private Map editors;
    public static int CALLEE_SIZE = 100000;

    private static void db(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }

    public Inline(InlineContext context, int maxCodeSize) {
        this.context = context;
        this.maxCodeSize = maxCodeSize;
        this.maxCallDepth = 1;
        this.inlineExceptions = true;
        this.editors = new HashMap();
    }

    public void setMaxInlineSize(int maxInlineSize) {
    }

    public void setMaxCallDepth(int maxCallDepth) {
        this.maxCallDepth = maxCallDepth;
    }

    public void setInlineExceptions(boolean inlineExceptions) {
        this.inlineExceptions = inlineExceptions;
    }

    public void inline(MethodEditor method) {
        StackHeightCounter stackHeight = new StackHeightCounter(method);
        List code = method.code();
        boolean firstCall = true;
        int i = 0;
        while (i < code.size()) {
            Object o = code.get(i);
            if (o instanceof Instruction) {
                Instruction inst = (Instruction)o;
                if (inst.opcodeClass() == 184 || inst.opcodeClass() == 183) {
                    int newHeight;
                    MemberRef callee = (MemberRef)inst.operand();
                    Stack<MemberRef> callStack = new Stack<MemberRef>();
                    callStack.add(method.memberRef());
                    Inline.db("  Call: " + inst);
                    stackHeight.handle(inst);
                    int expectedHeight = stackHeight.height();
                    stackHeight.unhandle(inst);
                    int j = i;
                    i = this.inline(method, callee, i, callStack, stackHeight, firstCall);
                    if (j == i) {
                        stackHeight.handle(inst);
                        Inline.db("  " + i + "." + stackHeight.height() + ") " + inst);
                    }
                    Assert.isTrue((newHeight = stackHeight.height()) == 0 || newHeight == expectedHeight, "Inlining did not get the stack heights right: Expected " + expectedHeight + ", got " + newHeight);
                } else {
                    stackHeight.handle(inst);
                    Inline.db("  " + i + "." + stackHeight.height() + ") " + inst);
                }
                if (inst.isInvoke()) {
                    firstCall = false;
                }
            } else if (o instanceof Label) {
                Label label = (Label)o;
                stackHeight.handle(label);
                Inline.db("  " + i + "." + stackHeight.height() + ") " + label + (label.startsBlock() ? " (starts block)" : ""));
            }
            ++i;
        }
        method.setCode(code);
        if (DEBUG) {
            stackHeight = new StackHeightCounter(method);
            Inline.db("\nNew Code for " + method.declaringClass().name() + "." + method.name() + method.type());
            code = method.code();
            int j = 0;
            while (j < code.size()) {
                if (code.get(j) instanceof Label) {
                    Label label = (Label)code.get(j);
                    stackHeight.handle(label);
                    Iterator tryCatches = method.tryCatches().iterator();
                    while (tryCatches.hasNext()) {
                        TryCatch tryCatch = (TryCatch)tryCatches.next();
                        if (tryCatch.start().equals(label)) {
                            System.out.println(" Begin protected region");
                        }
                        if (tryCatch.end().equals(label)) {
                            System.out.println(" End protected region");
                        }
                        if (!tryCatch.handler().equals(label)) continue;
                        System.out.println(" Catch " + tryCatch.type());
                    }
                    System.out.println("  " + j + "." + stackHeight.height() + ") " + label + (label.startsBlock() ? " (starts block)" : ""));
                } else {
                    Instruction inst = (Instruction)code.get(j);
                    stackHeight.handle(inst);
                    System.out.println("  " + j + "." + stackHeight.height() + ") " + code.get(j));
                }
                ++j;
            }
            Iterator tryCatches = method.tryCatches().iterator();
            System.out.println("Exception information:");
            while (tryCatches.hasNext()) {
                TryCatch tryCatch = (TryCatch)tryCatches.next();
                System.out.println("  " + tryCatch);
            }
            System.out.println("");
        }
    }

    private int inline(MethodEditor caller, MemberRef callee, int index, Stack callStack, StackHeightCounter stackHeight, boolean firstCall) {
        boolean addEndLabel;
        Label endLabel;
        List code;
        Instruction newInst = null;
        if (this.context.ignoreMethod(callee)) {
            Inline.db("  Can't inline " + callee + ": it's ignored");
            return index++;
        }
        if (callStack.size() > this.maxCallDepth) {
            Inline.db("  Can't inline " + callee + ": max call depth (" + this.maxCallDepth + ") reached");
            return index++;
        }
        if (callStack.contains(callee)) {
            Inline.db("  Can't inline recursive call to " + callee);
            return index++;
        }
        String name = callee.name();
        int b = name.indexOf("$$BLOAT");
        if (b != -1) {
            name = name.substring(0, b);
            Type[] oldParams = callee.type().paramTypes();
            StringBuffer sb = new StringBuffer("(");
            int p = 1;
            while (p < oldParams.length) {
                sb.append(oldParams[p].descriptor());
                ++p;
            }
            sb.append(")" + callee.type().returnType());
            Type newType = Type.getType(sb.toString());
            MemberRef unBloated = new MemberRef(callee.declaringClass(), new NameAndType(name, newType));
            if (callStack.contains(unBloated)) {
                Inline.db("  Can't inline recursive call to " + callee);
                return index++;
            }
        }
        if ((code = caller.code()).size() > this.maxCodeSize) {
            Inline.db("  Can't inline " + callee + ": max code size (" + this.maxCodeSize + ") reached");
            return index++;
        }
        MethodEditor calleeMethod = null;
        try {
            calleeMethod = this.context.editMethod(callee);
        }
        catch (NoSuchMethodException ex) {
            System.err.println("Couldn't find method " + callee);
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        if (calleeMethod.isNative()) {
            Inline.db("  Can't inline " + callee + ": it's a native method");
            return index++;
        }
        if (calleeMethod.isSynchronized()) {
            Inline.db("  Can't inline " + callee + ": it's synchronized");
            return index++;
        }
        if (!this.inlineExceptions && calleeMethod.methodInfo().exceptionTypes().length > 0) {
            Inline.db("  Can't inline " + callee + ": it may throw an exception");
            return index++;
        }
        if (calleeMethod.code().size() > CALLEE_SIZE) {
            Inline.db("  Can't inline " + callee + ": it's too big");
            return index++;
        }
        if (calleeMethod.tryCatches().size() > 0 && stackHeight.height() > callee.type().stackHeight()) {
            Inline.db("  Can't inline " + callee + ": It catches an exception and there's stuff on the " + "stack");
            return index++;
        }
        Iterator tryCatches0 = calleeMethod.tryCatches().iterator();
        while (tryCatches0.hasNext()) {
            TryCatch tc1 = (TryCatch)tryCatches0.next();
            Iterator iter = stackHeight.tryCatches().iterator();
            while (iter.hasNext()) {
                TryCatch tc2 = (TryCatch)iter.next();
                Type t1 = tc1.type();
                Type t2 = tc2.type();
                if (t1 == null || t2 == null || !t1.equals(t2)) continue;
                Inline.db("  Can't inline " + callee + ": It catches the same type " + tc1.type().className() + " as the current protected region");
                return index++;
            }
        }
        if (!(!calleeMethod.isConstructor() || firstCall && caller.isConstructor())) {
            Inline.db("  Can't inline " + callee + ": It calls a normal constructor");
            return index++;
        }
        Instruction call = (Instruction)code.remove(index--);
        Inline.db("  Removing call: " + call);
        Assert.isTrue(call.opcodeClass() == 184 || call.opcodeClass() == 183, "Removing the wrong call instruction:" + call);
        callStack.push(callee);
        Inline.db("  Inlining call (" + callStack.size() + ") to " + callee.declaringClass() + "." + callee.name() + callee.type());
        this.context.getInlineStats().noteInlined();
        Mapper mapper = new Mapper(caller);
        Type[] paramTypes = callee.type().indexedParamTypes();
        if (!calleeMethod.isStatic()) {
            Type[] newParams = new Type[paramTypes.length + 1];
            newParams[0] = callee.declaringClass();
            int i = 0;
            while (i < paramTypes.length) {
                newParams[i + 1] = paramTypes[i];
                ++i;
            }
            paramTypes = newParams;
        }
        LocalVariable[] params = new LocalVariable[paramTypes.length];
        Inline.db("  Indexed params:");
        int i = 0;
        while (i < params.length) {
            params[i] = calleeMethod.paramAt(i);
            Inline.db("    " + i + ": " + params[i] + (params[i] != null ? " " + params[i].type() + " " : ""));
            ++i;
        }
        i = params.length - 1;
        while (i >= 0) {
            LocalVariable param = params[i];
            Type paramType = params[i].type();
            if (param.type() != null) {
                int opcode;
                Inline.db("  Param " + i + ": " + param + " of type " + paramType);
                LocalVariable newVar = mapper.map(param, paramType);
                if (paramType.isReference()) {
                    opcode = 58;
                } else {
                    switch (paramType.typeCode()) {
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: {
                            opcode = 54;
                            break;
                        }
                        case 7: {
                            opcode = 57;
                            break;
                        }
                        case 11: {
                            opcode = 55;
                            break;
                        }
                        case 6: {
                            opcode = 56;
                            break;
                        }
                        case 10: {
                            opcode = 54;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("What's a " + paramType + "doing as a method " + "parameter");
                        }
                    }
                }
                newInst = new Instruction(opcode, newVar);
                code.add(++index, newInst);
                stackHeight.handle(newInst);
                Inline.db("  " + index + "." + stackHeight.height() + "> " + newInst);
            }
            --i;
        }
        Iterator tryCatches = calleeMethod.tryCatches().iterator();
        while (tryCatches.hasNext()) {
            TryCatch tryCatch = (TryCatch)tryCatches.next();
            Label start = mapper.map(tryCatch.start());
            Label end = mapper.map(tryCatch.end());
            Label handler = mapper.map(tryCatch.handler());
            TryCatch newTryCatch = new TryCatch(start, end, handler, tryCatch.type());
            caller.addTryCatch(newTryCatch);
        }
        List inlineCode = calleeMethod.code();
        Object last = inlineCode.get(inlineCode.size() - 1);
        if (last instanceof Label) {
            endLabel = mapper.map((Label)last);
            addEndLabel = false;
        } else {
            endLabel = caller.newLabel();
            addEndLabel = true;
        }
        endLabel.setStartsBlock(true);
        firstCall = true;
        int j = 0;
        while (j < inlineCode.size()) {
            Object o = inlineCode.get(j);
            if (o instanceof Label) {
                Label label = (Label)o;
                Label newLabel = mapper.map(label);
                code.add(++index, newLabel);
                stackHeight.handle(newLabel);
                Inline.db("  " + index + "." + stackHeight.height() + "> " + newLabel + (newLabel.startsBlock() ? " (starts block)" : ""));
            } else {
                Assert.isTrue(o instanceof Instruction, "What is a " + o + " doing in the instruction stream?");
                Instruction inst = (Instruction)inlineCode.get(j);
                Object operand = inst.operand();
                int opcode = inst.opcodeClass();
                if (operand instanceof LocalVariable) {
                    LocalVariable local = mapper.map((LocalVariable)operand, inst.category() == 2);
                    operand = local;
                } else if (operand instanceof Label) {
                    Label label = mapper.map((Label)operand);
                    operand = label;
                } else if (operand instanceof IncOperand) {
                    IncOperand inc = (IncOperand)operand;
                    LocalVariable newLocal = mapper.map(inc.var(), Type.INTEGER);
                    operand = new IncOperand(newLocal, inc.incr());
                } else if (operand instanceof Switch) {
                    Switch oldSwitch = (Switch)operand;
                    Label newDefault = mapper.map(oldSwitch.defaultTarget());
                    Label[] oldTargets = oldSwitch.targets();
                    Label[] newTargets = new Label[oldTargets.length];
                    int i2 = 0;
                    while (i2 < newTargets.length) {
                        Label newTarget;
                        newTargets[i2] = newTarget = mapper.map(oldTargets[i2]);
                        ++i2;
                    }
                    operand = new Switch(newDefault, newTargets, oldSwitch.values());
                }
                if (inst.isReturn()) {
                    newInst = new Instruction(167, endLabel);
                    code.add(++index, newInst);
                    stackHeight.handle(newInst);
                    Inline.db("  " + index + "." + stackHeight.height() + "> " + newInst);
                } else if (inst.opcodeClass() == 184 || inst.opcodeClass() == 183) {
                    int newHeight;
                    newInst = new Instruction(opcode, operand);
                    code.add(++index, newInst);
                    stackHeight.handle(newInst);
                    int expectedHeight = stackHeight.height();
                    stackHeight.unhandle(newInst);
                    MemberRef nestedCall = (MemberRef)inst.operand();
                    int oldIndex = index;
                    index = this.inline(caller, nestedCall, index, callStack, stackHeight, firstCall);
                    if (index == oldIndex) {
                        stackHeight.handle(newInst);
                        Inline.db("  " + index + "." + stackHeight.height() + "> " + newInst);
                    }
                    Assert.isTrue((newHeight = stackHeight.height()) == 0 || newHeight == expectedHeight, "Inlining did not get the stack heights right: Expected " + expectedHeight + ", got " + newHeight);
                } else {
                    newInst = new Instruction(opcode, operand);
                    code.add(++index, newInst);
                    stackHeight.handle(newInst);
                    Inline.db("  " + index + "." + stackHeight.height() + "> " + newInst);
                }
                if (inst.isInvoke()) {
                    firstCall = false;
                }
            }
            ++j;
        }
        if (addEndLabel) {
            code.add(++index, endLabel);
            stackHeight.handle(endLabel);
            Inline.db("  " + index + "." + stackHeight.height() + "> " + endLabel + (endLabel.startsBlock() ? " (starts block)" : ""));
        }
        caller.setDirty(true);
        callStack.pop();
        return index;
    }
}

