/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.benchmark;

import EDU.purdue.cs.bloat.context.BloatContext;
import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassFile;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CounterDecorate
implements Opcode {
    private static final String COUNTER_TYPE = "I";
    private static final String COUNTER_RCNAME = "rcCount";
    private static final String COUNTER_AUNAME = "auCount";
    private static final String COUNTER_SUNAME = "suCount";
    private static final String COUNTER_MAIN = "LEDU/purdue/cs/bloat/benchmark/Counter;";
    private static int VERBOSE = 0;
    private static boolean FORCE = false;
    private static boolean CLOSURE = false;
    private static final List SKIP = new ArrayList();
    private static final List ONLY = new ArrayList();

    public static void main(String[] args) {
        ClassFileLoader loader = new ClassFileLoader();
        ArrayList<String> classes = new ArrayList<String>();
        boolean gotdir = false;
        int i = 0;
        while (i < args.length) {
            String pkg;
            if (args[i].equals("-v") || args[i].equals("-verbose")) {
                ++VERBOSE;
            } else if (args[i].equals("-help")) {
                CounterDecorate.usage();
            } else if (args[i].equals("-classpath")) {
                if (++i >= args.length) {
                    CounterDecorate.usage();
                }
                String classpath = args[i];
                loader.setClassPath(classpath);
            } else if (args[i].equals("-skip")) {
                if (++i >= args.length) {
                    CounterDecorate.usage();
                }
                pkg = args[i].replace('.', '/');
                SKIP.add(pkg);
            } else if (args[i].equals("-only")) {
                if (++i >= args.length) {
                    CounterDecorate.usage();
                }
                pkg = args[i].replace('.', '/');
                ONLY.add(pkg);
            } else if (args[i].equals("-closure")) {
                CLOSURE = true;
            } else if (args[i].equals("-relax-loading")) {
                ClassHierarchy.RELAX = true;
            } else if (args[i].equals("-f")) {
                FORCE = true;
            } else if (args[i].startsWith("-")) {
                CounterDecorate.usage();
            } else if (i == args.length - 1) {
                File f = new File(args[i]);
                if (f.exists() && !f.isDirectory()) {
                    System.err.println("No such directory: " + f.getPath());
                    System.exit(2);
                }
                loader.setOutputDir(f);
                gotdir = true;
            } else {
                classes.add(args[i]);
            }
            ++i;
        }
        if (!gotdir) {
            CounterDecorate.usage();
        }
        if (classes.size() == 0) {
            CounterDecorate.usage();
        }
        if (VERBOSE > 3) {
            ClassFileLoader.DEBUG = true;
            ClassEditor.DEBUG = true;
        }
        boolean errors = false;
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            try {
                loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Couldn't find class: " + ex.getMessage());
                errors = true;
            }
        }
        if (errors) {
            System.exit(1);
        }
        CachingBloatContext context = new CachingBloatContext(loader, classes, CLOSURE);
        if (!CLOSURE) {
            Iterator e = classes.iterator();
            while (e.hasNext()) {
                String name = (String)e.next();
                try {
                    ClassInfo info = loader.loadClass(name);
                    CounterDecorate.decorateClass(context, info);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println("Couldn't find class: " + ex.getMessage());
                    System.exit(1);
                }
            }
        } else {
            classes = null;
            ClassHierarchy hier = ((BloatContext)context).getHierarchy();
            Iterator e = hier.classes().iterator();
            while (e.hasNext()) {
                Type t = (Type)e.next();
                if (!t.isObject()) continue;
                try {
                    ClassInfo info = loader.loadClass(t.className());
                    CounterDecorate.decorateClass(context, info);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println("Couldn't find class: " + ex.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java EDU.purdue.cs.bloat.count.Main \n            [-options] classes output_dir\n\nwhere options include:\n    -help             print out this message\n    -v -verbose       turn on verbose mode (can be given multiple times)\n    -classpath <directories separated by colons>\n                      list directories in which to look for classes\n    -f                decorate files even if up-to-date\n    -closure          recursively decorate referenced classes\n    -relax-loading    don't report errors if a class is not found\n    -skip <class|package.*>\n                      skip the given class or package\n                      (this option can be given more than once)\n    -only <class|package.*>\n                      skip all but the given class or package\n                      (this option can be given more than once)");
        System.exit(0);
    }

    private static void decorateClass(EditorContext editor, ClassInfo info) {
        String pkg;
        int i;
        ClassFile classFile = (ClassFile)info;
        if (!FORCE) {
            File source = classFile.file();
            File target = classFile.outputFile();
            if (source != null && target != null && source.exists() && target.exists() && source.lastModified() < target.lastModified()) {
                if (VERBOSE > 1) {
                    System.out.println(String.valueOf(classFile.name()) + " is up to date");
                }
                return;
            }
        }
        if (VERBOSE > 2) {
            classFile.print(System.out);
        }
        ClassEditor c = editor.editClass(info);
        boolean skip = false;
        String name = c.type().className();
        String qual = String.valueOf(c.type().qualifier()) + "/*";
        if (ONLY.size() > 0) {
            skip = true;
            i = 0;
            while (i < ONLY.size()) {
                pkg = (String)ONLY.get(i);
                if (name.equals(pkg) || qual.equals(pkg)) {
                    skip = false;
                    break;
                }
                ++i;
            }
        }
        if (!skip) {
            i = 0;
            while (i < SKIP.size()) {
                pkg = (String)SKIP.get(i);
                if (name.equals(pkg) || qual.equals(pkg)) {
                    skip = true;
                    break;
                }
                ++i;
            }
        }
        if (skip) {
            if (VERBOSE > 0) {
                System.out.println("Skipping " + c.type().className());
            }
            editor.release(info);
            return;
        }
        if (VERBOSE > 0) {
            System.out.println("Decorating class " + c.type().className());
        }
        if (VERBOSE > 2) {
            ((ClassFile)info).print(System.out);
        }
        MethodInfo[] methods = c.methods();
        int j = 0;
        while (j < methods.length) {
            block17: {
                MethodEditor m;
                try {
                    m = editor.editMethod(methods[j]);
                }
                catch (ClassFormatException ex) {
                    System.err.println(ex.getMessage());
                    break block17;
                }
                CounterDecorate.transform(m);
                editor.commit(methods[j]);
            }
            ++j;
        }
        editor.commit(info);
    }

    private static void transform(MethodEditor method) {
        if (VERBOSE > 1) {
            System.out.println("Decorating method " + method);
        }
        MemberRef rcfield = new MemberRef(Type.getType(COUNTER_MAIN), new NameAndType(COUNTER_RCNAME, Type.getType(COUNTER_TYPE)));
        MemberRef aufield = new MemberRef(Type.getType(COUNTER_MAIN), new NameAndType(COUNTER_AUNAME, Type.getType(COUNTER_TYPE)));
        MemberRef sufield = new MemberRef(Type.getType(COUNTER_MAIN), new NameAndType(COUNTER_SUNAME, Type.getType(COUNTER_TYPE)));
        ListIterator<Instruction> iter = method.code().listIterator();
        while (iter.hasNext()) {
            Object ce = iter.next();
            if (VERBOSE > 2) {
                System.out.println("Examining " + ce);
            }
            if (!(ce instanceof Instruction)) continue;
            Instruction inst = (Instruction)ce;
            if (inst.opcodeClass() == 238) {
                iter.remove();
                iter.add(new Instruction(178, aufield));
                iter.next();
                iter.add(new Instruction(18, new Integer(1)));
                iter.next();
                iter.add(new Instruction(96));
                iter.next();
                iter.add(new Instruction(179, aufield));
                iter.next();
            }
            if (inst.opcodeClass() == 239) {
                iter.remove();
                iter.add(new Instruction(178, sufield));
                iter.next();
                iter.add(new Instruction(18, new Integer(1)));
                iter.next();
                iter.add(new Instruction(96));
                iter.next();
                iter.add(new Instruction(179, sufield));
                iter.next();
                continue;
            }
            if (inst.opcodeClass() != 237) continue;
            iter.remove();
            iter.add(new Instruction(178, rcfield));
            iter.next();
            iter.add(new Instruction(18, new Integer(1)));
            iter.next();
            iter.add(new Instruction(96));
            iter.next();
            iter.add(new Instruction(179, rcfield));
            iter.next();
        }
    }
}

